;----------------------------------------------------------------------------
; MUGEN
; PCLauncher.exe
; by djvj (original HL1.0 script by brolly)
; 1.0
;
; Notes:
;Blank txt files need to be created for every game
;settings.ini needs to reside with the blank txt files and contain an entry for each game, pointing to the OpenBOR.exe
;example:
;
;[Bastard]
;gamePath = Bastard\WinBastard.exe
;[Mortal Kombat Anthology]
;gamePath = Mortal Kombat Anthology\Mortal Kombat Anthology.exe
;
;emuPath and exe need to point to a dummy exe, like PCLauncher.exe
;romPath needs to point to the dir with all the blank txt files and the settings.ini
;Escape will only close the game from the main menu, it is needed for in-game menu usage otherwise.
;Controls are done via in-game options for each game.
;Larger games are inherently slower to load, this is MUGEN, nothing you can do about it but get a faster HD.
;----------------------------------------------------------------------------

IniRead, gamePath, %romPath%Settings.ini, %romName%, gamePath
Run, "%romPath%%gamePath%", %romPath%%romName%,, game_PID
Sleep 1500

WinGetTitle, gameTitle, ahk_pid %game_PID%

;Sometimes mugen crashes during exit and doesn't close, so we need to do a workaround to detect it
If ( gameTitle != "HyperSpin" )
{
;If the user exited mugen in under 1500ms then we don't need to do this otherwise the script would hang
	IfWinExist, %gameTitle%
	{
		Loop
		{
			Sleep, 1000
			WinGet, gameState, MinMax, %gameTitle%
			If ( gameState != 1 )
			{
				;Mugen window minimized or closed
				Break
			}
		}
	}
}

Sleep 2000

If ( gameTitle != "HyperSpin" )
{
	IfWinExist, %gameTitle%
	{
		Process, Close, %game_PID%
	}
}
Process, Close, %executable% ;on some machines/games, MUGEN doesn't close itself properly, this is the work around to make sure it does
WinActivate, HyperSpin

ExitApp
           
CloseProcess:
return